//
//     GESTOR DE NODOS     
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella
   ALUMNO:    Ernesto Jess de la Rubia Cuestas.
   VERSIN:   1.0
   FECHA:     04/11/2002
   DESCRIPCIN:
                Se usan dos ficheros de configuracin para guardar los datos de
                los nodos. Un fichero para nodos VRML y otro para nodos Reachin.
                Esta clase permite acceder a los datos guardado en estos ficheros.
*/

#include <vcl.h>
#pragma hdrstop

#include "GestorNodos_.h"
#include "Utilidad_.h"
#include "Main_.h"
#include "Configuracion_.h"

// En la declaracin de los campos hay referencias a tipos que no existen en
// la relacin de tipos. As en estos campos se apunta a una estructura Tipo
// que tienen como nombre del tipo esta cadena:
#define CAD_TIPO_INDEFINIDO "<Tipo Indefinido>"

/* Este es un ejemplo del formato de un nodo en el fichero de configuracin
----------------------------------------------------------------------------------------
<<<Nodo>>>
    Nombre:      Viewpoint
    Descripcin: Nodo Bindable que describe las propiedades de la cmara (posicin, direccin, etc.)
    Tipo:        Nodos Bindable
    Icono:       Viewpoint30.bmp
    Imagen:      Viewpoint.bmp
    Campos VRML:
      Rutado   Nombre             Tipo               Val.Defecto
     -------- --------           ------             -------------
       <-     set_bind           SetBindEvent
       <->    fieldOfView        SFFloat            0.785398
       <->    jump               SFBool             TRUE
       <->    orientation        SFRotation         0 0 1 0
       <->    position           SFVec3f            0 0 10
        -     description        SFString           ""
        ->    bindTime           SFTime
        ->    isBound            SFBool
        ->    accumulatedForward SFMatrix4f         identity
        ->    accumulatedInverse SFMatrix4f         identity
----------------------------------------------------------------------------------------
*/

//--------------------  COSTANTES ----------------------------------------------
// Esta cadena es la que marca el inicio de la informacin de los nodos.
#define MARCA_DE_INICIO "<<<LISTADO DE NODOS>>>"

// Esta cadena es la que marca el inicio de la informacin de los nodos.
#define MARCA_DE_NODO "<<<Nodo>>>"

// Estas son las marcas que se usan para buscar la informacin de cada nodo:
#define MARCA_DE_NOMBRE "Nombre:"
#define MARCA_DE_DESCRIPCION "Descripcin:"
#define MARCA_DE_TIPO "Tipo:"
#define MARCA_DE_ICONO "Icono:"
#define MARCA_DE_IMAGEN "Imagen:"
#define MARCA_DE_CONTAINER_FIELD "ContainerField:"
#define MARCA_DE_CAMPOS_VRML "Campos VRML:"

// Para alinear en columnas los ficheros de configuracin de nodos se usan estas
// constantes:
#define COLUMNA_1 4
#define COLUMNA_1B 17
#define COLUMNA_2 7
#define COLUMNA_3 14
#define COLUMNA_4 33
#define COLUMNA_5 52

//------------------------------------------------------------------------------
#pragma package(smart_init)

//------------------------------------------------------------------------------
void GestorNodos::CargarFichConf(AnsiString configfile,int tipoEscena_, GestorTipos *GT){
   long int numNodosLocal;
   AnsiString pal,cad;
   Nodo  *nodoLeido;
   Campo *campoLeido;
   int index=0;
   int indexTmp;


   // Algunos nombres de tipos Reachin no aparecen definidos explicitamente
   // como tipos sino que son nombres de nodos de modo que se sobreentiende
   // que son tipos SFNode -> Para controlar esto usaremos tiposIndefinidos.
   TStringList *tiposDesconocidos=NULL;
   try{ tiposDesconocidos = new TStringList; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   tipoEscena=tipoEscena_;
   TiposNodo->Clear();

   // Empezamos abriendo el fichero de configuracin.
   Utilidad::LoadFromFile(Lineas,configfile);

   // Lo primero que hacemos es buscar la cadena de texto que indica dnde
   // empieza la informacin de los nodos.

   while( (index < Lineas->Count) && ( 0 == Lineas->Strings[index++].UpperCase().Pos(MARCA_DE_INICIO)));
   if(index >= Lineas->Count)
      Utilidad::FatalError("Format error in the configuration file: " + configfile);

   // Ahora comenzamos con la lectura de los nodos.
   // En primer lugar vamos a contar el nmero de nodos que hay en el fichero.
   indexTmp=index;
   numNodosLocal=0;
   while(indexTmp < Lineas->Count){
      if( 0 != Lineas->Strings[indexTmp++].Pos(MARCA_DE_NODO))
        numNodosLocal++;
   }

   if(numNodosLocal==0){
      Utilidad::MsgInfo("There aren't nodes in the configuration file.","Error");
      LiberaMemoria();
      return;
   }

   // Creamos el array de punteros a estructuras tipo nodo teniendo en cuenta
   // si hay que aadir o no nuevos nodos.
   LiberaMemoria(); // Si ya hay nodos cargados se liberar la memoria.
   try{ Nodos= new (Nodo *[numNodosLocal]); }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }
   NumNodos=0;

   // Guardaremos en nombresCampos los nombres de todos los campos.
   NombresCampos->Clear();
   AnsiString msgError = "Format error in  " + configfile;

   while( index < Lineas->Count ){

      // Lo primero es buscar la siguiente marca de Nodo:
      while( (index < Lineas->Count) &&
             (0 == Lineas->Strings[index++].Pos(MARCA_DE_NODO)) );

      if(index >= Lineas->Count)
         // No hemos encontrado la siguiente marca de nodo -> damos por
         // finalizada la bsqueda:
         break; 

      // Se ha encontrado un nodo -> Creamos un nuevo nodo en memoria.
      try{ nodoLeido= new Nodo; }
      catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

      // Vinculamos el nuevo nodo al array:
      Nodos[NumNodos]=nodoLeido;
      NumNodos++;
      // Ponemos todos campos a NULL por si salimos de la funcin por algn error.
      nodoLeido->campos=NULL;

      // A continuacin rellenamos los campos del nodo:
      // NOMBRE 
      if(!Busca(index,MARCA_DE_NOMBRE,nodoLeido->nombre))
         Utilidad::FatalError(msgError);

      // DESCRIPCION  
      if(!Busca(index,MARCA_DE_DESCRIPCION,nodoLeido->descripcion))
         Utilidad::FatalError(msgError);

      // TIPO DE NODO
      if(!Busca(index,MARCA_DE_TIPO,nodoLeido->tipo))
         Utilidad::FatalError(msgError);

      // ICONO 
      if(!Busca(index,MARCA_DE_ICONO,nodoLeido->icono))
         Utilidad::FatalError(msgError);

      // IMAGEN 
      if(!Busca(index,MARCA_DE_IMAGEN,nodoLeido->imagen))
         Utilidad::FatalError(msgError);

      // CONTAINER FIELD  
      if(!Busca(index,MARCA_DE_CONTAINER_FIELD,nodoLeido->containerField))
         Utilidad::FatalError(msgError);

      //
      // LECTURA  DE CAMPOS VRML 
      //
      if(!Busca(index,MARCA_DE_CAMPOS_VRML,cad))
         Utilidad::FatalError(msgError);

      // Tenemos index en la siguiente lnea a la que contiene MARCA_DE_CAMPOS
      // Ahora hay que absorvar 2 lneas ms:
      index+=2;

      // Necesitamos saber previamente el nmero de campos que hay -> Los contamos.
      indexTmp=index;
      bool seguir = true;
      int numCampos=0;
      while( (indexTmp < Lineas->Count) && seguir ){
         cad = Utilidad::GetPalabra(Lineas->Strings[indexTmp++],1);
         if( (cad == "-") || (cad == "<-") || (cad == "->") || (cad == "<->") )
            numCampos++;
         else
            seguir=false;
      }

      nodoLeido->numCampos=numCampos;
      nodoLeido->campos = NULL;

      if( nodoLeido->numCampos > 0 ){
         // Ahora creamos el array de punteros a estructuras tipo campo.
         try{ nodoLeido->campos=new Campo *[nodoLeido->numCampos]; }
         catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

         // Hay que poner todos los punteros de la estructura a NULL por si
         // salimos del programa con algn error.
         for(int it=0; it < nodoLeido->numCampos ; it++)
            nodoLeido->campos[it]=NULL;

         // Empezamos a leer los campos -> Lineas->String[index] contiene el primero:
         // por el bucle anterior tenemos garantizado que podemos leer numCampos de
         // Lineas a partir de Index as:
         for(int c=0; c < nodoLeido->numCampos; c++){
            // Creamos un nuevo campo en memoria.
            try{ nodoLeido->campos[c]=new Campo; }
            catch(...){ Utilidad::FatalErrorFaltaMemoria(); }
            nodoLeido->campos[c]->tipo=NULL;
            // en cad tenemos toda la informacin del campo:
            cad = Lineas->Strings[index++];

            // Leemos los datos del nodo Actual.
            //CAMPO->RUTADO 
            pal = Utilidad::CortaPrimeraPalabra(cad);

            if     ( pal == "<->") nodoLeido->campos[c]->rutado=EXPOSEDFIELD;
            else if( pal == "<-" ) nodoLeido->campos[c]->rutado=EVENTIN;
            else if( pal == "->" ) nodoLeido->campos[c]->rutado=EVENTOUT;
            else if( pal == "-"  ) nodoLeido->campos[c]->rutado=FIELD;

            //  CAMPO->NOMBRE
            nodoLeido->campos[c]->nombre = Utilidad::CortaPrimeraPalabra(cad);
            if( -1 == NombresCampos->IndexOf(nodoLeido->campos[c]->nombre) )
                NombresCampos->Append(nodoLeido->campos[c]->nombre);

            //  CAMPO->TIPO  
            // Hay que asignarlo usando el gestor de tipos.
            // Algunos tipos que aparecen en la definicin de los nodos no estn
            // definidos y por eso esta funcin devuelve NULL. Esto puede dar
            // problemas si en alguna parte del cdigo se olvida comprobar que
            // el puntero no es NULL as que vamos a asegurar que ningn puntero
            // a tipo sea NULL usaremos la variable global, TipoDesconocido;
            pal = Utilidad::CortaPrimeraPalabra(cad);
            nodoLeido->campos[c]->tipo = GT->DatosTipo(pal);
            if( nodoLeido->campos[c]->tipo == NULL ){
               /* Es posible que se lean nombres de tipos que no estn cargados
               el el gestor de tipos esto es debido a que en Reachin se usan
               como nombres de tipos los nombres de los nodos, de modo que se
               sobreentiende que se trata de un tipo SFNode que tiene como hijo
               un nodo que tiene ese nombre. Los asignaremos como tipos desconocidos.*/
               nodoLeido->campos[c]->tipo = TipoDesconocido;
               AnsiString msg = (AnsiString) "Tipo: " + pal + " Campo: " + nodoLeido->campos[c]->nombre + " Nodo: " + nodoLeido->nombre;
               tiposDesconocidos->Append(msg);
               // Guardamos en este nombre:
               nodoLeido->campos[c]->nombreTipoIndefinido = pal;
            }

            //  CAMPO->V.DEFECTO
            // A continuacin tenemos que leer el valor por defecto que est
            // compuesto por un numero variable de palabras.
            nodoLeido->campos[c]->valorPorDefecto = cad.Trim();
         }
      }
   }

   // Ahora Guardamos en un TStringList los tipos de nodos que hemos encontrado.
   TiposNodo->Clear();
   for(int i=0; i < NumNodos;i++){
      if( -1 == TiposNodo->IndexOf( Nodos[i]->tipo) )
         TiposNodo->Add( Nodos[i]->tipo);
   }

   /*  // ???
     if( tiposDesconocidos->Count > 3){
        MessageDlg("Actualmente hay " + IntToStr(tiposDesconocidos->Count) + " campos indefinidos. Se han salvado a TiposDesconocidos.txt", mtInformation,TMsgDlgButtons() << mbOK,0);
        Utilidad::SaveToFile(tiposDesconocidos,"TiposDesconocidos.txt");
  } */
  delete tiposDesconocidos;

  // No necesitaremos el contenido de Lineas -> As que liberemos memoria:
  Lineas->Clear();
}
//------------------------------------------------------------------------------
int GestorNodos::GetNumNodos(){
     return NumNodos;
}
//------------------------------------------------------------------------------
Nodo *GestorNodos::DatosNodo(int i){
   if( (NumNodos > 0) && (i < NumNodos) && (i >= 0) & (Nodos!=NULL))
      return Nodos[i];
   else
      return NULL;
}
//------------------------------------------------------------------------------
Nodo *GestorNodos::DatosNodo(AnsiString nombrenodo){
   if( (NumNodos == 0) || (Nodos==NULL) )
      return NULL;

   for(int c=0;c < NumNodos;c++){
      if( (Nodos[c] != NULL) && ( nombrenodo == Nodos[c]->nombre) )
         return Nodos[c];
   }
   return NULL;
}
//------------------------------------------------------------------------------
AnsiString GestorNodos::GetContainerField(AnsiString nombrenodo)
{
   if( (NumNodos == 0) || (Nodos==NULL) )
      return "";

   for(int c=0;c < NumNodos;c++)
   {
      if( (Nodos[c] != NULL) && ( nombrenodo == Nodos[c]->nombre) )
         return Nodos[c]->containerField;
   }
   return "";
}
//------------------------------------------------------------------------------
int GestorNodos::NumeroDeNodo(AnsiString nombrenodo){
   if( (NumNodos == 0) || (Nodos == NULL) || nombrenodo=="" )
      return -1;
   for(int c=0;c < NumNodos;c++){
      if( (Nodos[c] != NULL) && ( nombrenodo == ( Nodos[c]->nombre) ))
         return c;
   }
   return -1;
}
//------------------------------------------------------------------------------
Campo *GestorNodos::DatosCampo(int nodo,int campo){
   if( (NumNodos != 0) && (nodo < NumNodos) && (nodo >= 0) && (Nodos!=NULL)){
      if( (Nodos[nodo] != NULL) && (Nodos[nodo]->campos != NULL ) && (Nodos[nodo]->numCampos > campo) )
         return Nodos[nodo]->campos[campo];
   }
   return NULL;
}
//------------------------------------------------------------------------------
void GestorNodos::AsignarTipoDesconocido(){
   // Vamos a crear un tipo que asignaremos a los campos de los nodos que
   // tengan tipos indefinidos.

   try{ TipoDesconocido = new Tipo(); }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   // Asignamos el campo nombre
   TipoDesconocido->nombre      = CAD_TIPO_INDEFINIDO;
   TipoDesconocido->nombreIcono = CONF.ICONO_GENERAL_TIPO;

   // Asignamos el campo icono.
   try{ TipoDesconocido->icono = new TPicture; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   // Cargamos la imagen en memoria.
   Utilidad::GetImagen(TipoDesconocido->icono,CONF.ICONO_GENERAL_TIPO,"");

   TipoDesconocido->ejemplo="-";
   TipoDesconocido->numHijos=0;
}
//------------------------------------------------------------------------------
bool GestorNodos::EsCampo(AnsiString campo){
   return (-1 != NombresCampos->IndexOf(campo));
}
//------------------------------------------------------------------------------
bool GestorNodos::Busca(int &index,AnsiString marca,AnsiString &cad){

   // Lo primero es avanzar index hasta encontrar marca:
   while( (index < Lineas->Count) && ( 0 == Lineas->Strings[index].TrimLeft().Pos(marca)))
      index++;
   if(index >= Lineas->Count)
      return false;
   // Se ha encontrado la cadena marca en Lineas->Strings[index]
   cad = Lineas->Strings[index];
   Utilidad::CortaPrimeraPalabra(cad);
   cad = cad.TrimLeft();
   index++;
   return true;
}
//------------------------------------------------------------------------------
GestorNodos::GestorNodos(){
   try{
      TiposNodo     = new TStringList;
      NombresCampos = new TStringList;
      Lineas        = new TStringList;
   }catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   NumNodos=0;
   Nodos=NULL;
   AsignarTipoDesconocido();
   CreaNodoGenerico();
}

//------------------------------------------------------------------------------
GestorNodos::GestorNodos(AnsiString configfile,int tipoEscena_,GestorTipos *GT){
   try{
      TiposNodo     = new TStringList;
      NombresCampos = new TStringList;
      Lineas        = new TStringList;
   }catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   NumNodos=0;
   Nodos=NULL;
   AsignarTipoDesconocido();
   CreaNodoGenerico();
   CargarFichConf(configfile,tipoEscena_,GT);
}
//------------------------------------------------------------------------------
GestorNodos::~GestorNodos(){

   LiberaMemoria();
   delete TiposNodo;
   delete NombresCampos;
   delete Lineas;

   if(TipoDesconocido->icono != NULL)
      delete TipoDesconocido->icono;
   // Por ltimo borramos la estructura.
   if(TipoDesconocido != NULL)
      delete TipoDesconocido;
   if(NodoGenerico != NULL)
      delete NodoGenerico;
}
//------------------------------------------------------------------------------
void GestorNodos::LiberaMemoria(){
   if(Nodos==NULL)
      return;
   for(int it=0; it < NumNodos ; it++){
      if(Nodos[it] != NULL)
         LiberaMemoriaNodo(it);
   }
   if(TiposNodo!=NULL)
      TiposNodo->Clear();
   delete Nodos;      
   Nodos=NULL;
   NumNodos=0;
}
//-----------------------------------------------------------------------------
void GestorNodos::LiberaMemoriaNodo(int index){
  if( (index < 0) || (index >= NumNodos) )
     return;

  Nodo *nodo = Nodos[index];
  if(nodo == NULL)
     return;

  if(nodo->campos != NULL){
     for(int c=0; c < nodo->numCampos; c++){
        if(nodo->campos[c] != NULL)
           delete nodo->campos[c];
     }
     delete nodo->campos;
  }
  delete nodo;
  Nodos[index]=NULL;
}
//-----------------------------------------------------------------------------
void GestorNodos::EliminarNodo(int index){
   if( (Nodos == NULL) || (index >= NumNodos) )
      return;

   // Borramos el Nodo asociado a index:
   LiberaMemoriaNodo(index);

   // Ahora tenemos que considerar este caso especial:
   if( NumNodos == 1){
      NumNodos == 0;
      delete Nodos;
      Nodos= NULL;
      return;
   }

   // Ahora hay que crear un array nuevo:
   Nodo **nodosTmp;
   try{ nodosTmp = new (Nodo *[NumNodos - 1]); }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   int indexNuevo=0;
   // Ahora copiamos el array antiguo en el nuevo:
   for(int c=0; c < NumNodos; c++){
      if( c != index)
         nodosTmp[indexNuevo++] = Nodos[c];
   }

   NumNodos--;

   // Ya podemos borrar Tipos:
   delete Nodos;
   Nodos = nodosTmp;
}
//-----------------------------------------------------------------------------
Nodo *GestorNodos::AnadirNodo(){
   // Nodos podra ser NULL y todo funcionara bien:
   // if(Nodos == NULL) return;

   // Lo primero es reservar memoria para un nuevo nodo:
   Nodo *nuevo;
   try{ nuevo= new Nodo; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }
   nuevo->campos = NULL;
   nuevo->numCampos = 0;
   // El resto de elementos de nodo son AnsiString y no hay que inicializarlos.

   // Ahora tenemos que ampliar el array:
   Nodo **nodosTmp;
   try{ nodosTmp = new (Nodo *[NumNodos + 1]); }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   // Ahora copiamos el array antiguo en el nuevo:
   for(int c=0; c < NumNodos; c++)
      nodosTmp[c] = Nodos[c];

   // Ya podemos borrar Nodos:
   if(Nodos != NULL)
      delete Nodos;
   Nodos = nodosTmp;

   // Ahora asignamos el nuevo nodo.
   if(nuevo != NULL)
      // Aadimos nuevo a la ltima posicion de Nodos:
      Nodos[NumNodos++] = nuevo;

   return nuevo;
}
//-----------------------------------------------------------------------------
void GestorNodos::CargaInfoEnLineas(){

   AnsiString tipo = (tipoEscena == ESCENA_REACHIN) ? "Reachin" : "VRML";

   Lineas->Clear();

   Lineas->Append("");
   if(tipoEscena == ESCENA_REACHIN)
      Lineas->Append("  FICHERO DE CONFIGURACIN DE NODOS REACHIN  ");
   else
      Lineas->Append("  FICHERO DE CONFIGURACIN DE NODOS VRML  ");
   Lineas->Append("");
   Lineas->Append("   E.T.S. DE INGENIEROS DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA");
   Lineas->Append("   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E");
   Lineas->Append("                                    INTERFACES 3D CON SENSACIN TCTIL");
   Lineas->Append("   TUTOR:    Antonio Daz Estrella");
   Lineas->Append("   ALUMNO:   Ernesto Jess de la Rubia Cuestas");
   Lineas->Append("   VERSIN:  1.0");
   Lineas->Append("   FECHA:    09/12/2002");
   Lineas->Append("");
   Lineas->Append("  El objetivo de los ficheros de configuracin de nodos es ofrecer el mayor");
   Lineas->Append("grado de generalizacin posible al enfocar el diseo del programa. El usuario");
   Lineas->Append("puede cambiar estos ficheros de configuracin para adaptar el programa a nuevas");
   Lineas->Append("versiones VRML/Reachin sin necesidad de modificar el cdigo.");
   Lineas->Append("");

   if(tipoEscena == ESCENA_REACHIN){
      Lineas->Append(" Este fichero almacena los datos de los nodos de las libreras Reachin API.");
      Lineas->Append("");
      Lineas->Append(" MUY IMPORTANTE !!! -> En las libreras API de Reachin hay campos que pueden");
      Lineas->Append("producir daos fsicos al Phantom como por ejemplo ignore_manuf_max_force y");
      Lineas->Append("room_temperature del nodo PhantomDevice. Para evitar posibles errores no se");
      Lineas->Append("incluyen los campos de este nodo en los ficheros de configuracin que se usan");
      Lineas->Append("por defecto.");
   }else
      Lineas->Append("  Este fichero almacena los datos de los nodos VRML97 (ISO 14772)");
   Lineas->Append("");
   Lineas->Append("----------------------------------------------------------------------------------------");
   Lineas->Append(MARCA_DE_INICIO);
}
//-----------------------------------------------------------------------------
bool GestorNodos::SalvarFichConf(AnsiString configfile){

   AnsiString cad;
   AnsiString col1=AnsiString::StringOfChar(' ',COLUMNA_1);
   AnsiString col2=AnsiString::StringOfChar(' ',COLUMNA_2);

   Nodo  *nodo;
   Campo *campo;
   CargaInfoEnLineas();
   for(int c1=0; c1 < NumNodos ; c1++){
      nodo=Nodos[c1];
      if(nodo != NULL){

         Lineas->Append("----------------------------------------------------------------------------------------");
         // MARCA DE INICIO 
         Lineas->Append(MARCA_DE_NODO);
         // NOMBRE 
         cad = col1 + MARCA_DE_NOMBRE;
         do{ cad+=" "; }
         while(cad.Length() < COLUMNA_1B);
         cad+=nodo->nombre;
         Lineas->Append(cad);
         // DESCRIPCION 
         cad = col1 + MARCA_DE_DESCRIPCION;
         do{ cad+=" "; }
         while(cad.Length() < COLUMNA_1B);
         cad+=nodo->descripcion;
         Lineas->Append(cad);
         // TIPO 
         cad = col1 + MARCA_DE_TIPO;
         do{ cad+=" "; }
         while(cad.Length() < COLUMNA_1B);
         cad+=nodo->tipo;
         Lineas->Append(cad);
         // ICONO 
         cad = col1 + MARCA_DE_ICONO;
         do{ cad+=" "; }
         while(cad.Length() < COLUMNA_1B);
         cad+=nodo->icono;
         Lineas->Append(cad);
         // IMAGEN 
         cad = col1 + MARCA_DE_IMAGEN;
         do{ cad+=" "; }
         while(cad.Length() < COLUMNA_1B);
         cad+=nodo->imagen;
         Lineas->Append(cad);
         // IMAGEN 
         cad = col1 + MARCA_DE_CONTAINER_FIELD;
         do{ cad+=" "; }
         while(cad.Length() < COLUMNA_1B);
         cad+=nodo->containerField;
         Lineas->Append(cad);
         // CAMPOS 
         cad = col1 + MARCA_DE_CAMPOS_VRML;
         Lineas->Append(cad);

         cad = col1 + (AnsiString)"  Rutado   Nombre             Tipo               Val.Defecto";
         Lineas->Append(cad);
         cad = col1 + (AnsiString)" -------- --------           ------             -------------";
         Lineas->Append(cad);

         // Ahora hay que escribir los campos:
         if(nodo->campos != NULL){
            for(int c2=0; c2 < nodo->numCampos; c2++){
               campo = nodo->campos[c2];
               if(campo != NULL){
                  cad = col2;
                  // CAMPO: RUTADO 
                  switch(campo->rutado){
                     case EXPOSEDFIELD: cad+="<->";   break;
                     case EVENTIN     : cad+="<- ";   break;
                     case EVENTOUT    : cad+=" ->";   break;
                     case FIELD       : cad+=" - ";   break;
                  }
                  // CAMPO: NOMBRE 
                  do{ cad+=" "; }
                  while(cad.Length() < COLUMNA_3);
                  cad+= campo->nombre;
                  // CAMPO: TIPO 
                  do{ cad+=" "; }
                  while(cad.Length() < COLUMNA_4);
                  if( (campo->tipo != NULL) && (campo->tipo != TipoDesconocido) )
                     cad+= campo->tipo->nombre;
                  else
                     cad+= campo->nombreTipoIndefinido;
                  // CAMPO: NOMBRE 
                  do{ cad+=" "; }
                  while(cad.Length() < COLUMNA_5);
                  cad+= campo->valorPorDefecto;
                  Lineas->Append(cad);
               }
            }
         }
      }
   }
   return Utilidad::SaveToFile(Lineas,configfile);
}
//-----------------------------------------------------------------------------
void GestorNodos::EliminarTodos(){
   LiberaMemoria();
}
//-----------------------------------------------------------------------------
void GestorNodos::EliminarCampo(int indexNodo,int indexCampo){

   Nodo *nodo = DatosNodo(indexNodo);
   if( (nodo == NULL) || (indexCampo < 0) || (indexCampo >= nodo->numCampos) ||
       (nodo->numCampos == 0) || (nodo->campos == NULL) )
      return;

   // Lo primero es liberar la memoria del campo que no deseamos.
   if(nodo->campos[indexCampo] != NULL){
      delete nodo->campos[indexCampo];
      nodo->campos[indexCampo] = NULL;
   }
   // Ahora consideramos el caso especial en el que solo hay un campo:
   if(nodo->numCampos == 1){
      // Liberamos la memoria que ocupa el array:
      delete nodo->campos;
      nodo->campos==NULL;
   }else{
      // Ahora creamos un array de campos:
      Campo **campos;
      try{ campos=new Campo *[nodo->numCampos-1]; }
      catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

      // Ahora copiamos el array antiguo en el nuevo:
      int index=0;
      for(int c=0; c < nodo->numCampos; c++){
         if(c != indexCampo)
            campos[index++] = nodo->campos[c];
      }
      // Ya hemos copiado el array antiguo en el nuevo. Ahora reasignamos
      // las variables y liberamos la memoria del array antiguo:
      delete nodo->campos;
      nodo->campos=campos;
   }

   // Finalmente decrementamos el nmero de campos del nodo:
   nodo->numCampos--;
}
//-----------------------------------------------------------------------------
void GestorNodos::AnadirCampo(int indexNodo,AnsiString nombre,Tipo *tipo,
                              TipoRutadoCampo rutado,AnsiString valorPorDef){

   Nodo *nodo = DatosNodo(indexNodo);
   if(nodo == NULL) 
      return;

   // Lo primero crear en memoria el campo que vamos a aadir:
   Campo *campo = NULL;
   try{ campo = new Campo; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   campo->nombre = nombre;
   campo->tipo   = tipo;
   campo->rutado = rutado;
   campo->valorPorDefecto = valorPorDef;

   // Creamos un array de campos:
   Campo **campos;
   try{ campos=new Campo *[nodo->numCampos+1]; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   // Ahora copiamos el array antiguo en el nuevo:
   for(int c=0; c < nodo->numCampos; c++)
      campos[c] = nodo->campos[c];

   // Aadimos al final el nuevo elemento:
   campos[nodo->numCampos] = campo;
   // Ya hemos copiado el array antiguo en el nuevo. Ahora reasignamos
   // las variables y liberamos la memoria del array antiguo:
   if(nodo->campos != NULL)
      delete nodo->campos;
   nodo->campos=campos;

   // Finalmente incrementamos el nmero de campos del nodo:
   nodo->numCampos++;
}
//-----------------------------------------------------------------------------
void GestorNodos::CreaNodoGenerico(){

   // Reservamos memoria:
   try{ NodoGenerico = new Nodo; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   NodoGenerico->nombre = "NodoGenerico";
   NodoGenerico->descripcion= "Se asocia a los nodos no registrados como nodos VRML/Reachin.";
   NodoGenerico->tipo="";
   NodoGenerico->icono="";
   NodoGenerico->imagen="";
   NodoGenerico->numCampos=1;
   // Solo falta crear el campo:
   try{ NodoGenerico->campos=new Campo *[1]; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   try{ NodoGenerico->campos[0]=new Campo; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   NodoGenerico->campos[0]->nombre = "datos";
   NodoGenerico->campos[0]->tipo=TipoDesconocido;

   NodoGenerico->campos[0]->valorPorDefecto = "";
   // Hay que usar el caso ms restrictivo para que no se puedan hacer
   // "cosas raras" como rutar un campo con un trozo de texto.
   NodoGenerico->campos[0]->rutado = FIELD;
   NodoGenerico->campos[0]->nombreTipoIndefinido="";
}


